<?php
require_auth();
require __DIR__ . '/../db.php';
require __DIR__ . '/../helpers.php';
require __DIR__ . '/../services/perdas_import_service.php';

if (is_file(__DIR__ . '/../../vendor/autoload.php')) {
    require_once __DIR__ . '/../../vendor/autoload.php';
}

require __DIR__ . '/_layout_top.php';

$err = '';
$ok = '';
$result = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_check();

    if (!isset($_FILES['arquivo_xlsx']) || !is_uploaded_file($_FILES['arquivo_xlsx']['tmp_name'])) {
        $err = 'Selecione um arquivo XLSX para importar.';
    } elseif (strtolower(pathinfo($_FILES['arquivo_xlsx']['name'], PATHINFO_EXTENSION)) !== 'xlsx') {
        $err = 'Formato invalido. Envie um arquivo .xlsx';
    } elseif (!class_exists('Shuchkin\\SimpleXLSX')) {
        $err = 'Dependencia de importacao nao encontrada. Rode composer install.';
    } else {
        try {
            $result = perdas_import_from_xlsx($_FILES['arquivo_xlsx']['tmp_name'], db(), (int)(auth_user()['id'] ?? 0));
            $ok = 'Importacao concluida com sucesso.';
        } catch (Throwable $e) {
            $err = 'Falha na importacao: ' . $e->getMessage();
        }
    }
}
?>

<section class="glass-card p-5 md:p-6">
  <div class="flex flex-wrap items-center justify-between gap-3">
    <div>
      <p class="text-xs uppercase tracking-[0.15em] text-mnc-muted">Carga de Dados</p>
      <h1 class="mt-1 text-2xl font-extrabold">Importar Planilha de Perdas (XLSX)</h1>
    </div>
    <a class="btn-muted" href="<?= e(route_url('dashboard')) ?>">Voltar ao Dashboard</a>
  </div>
  <p class="mt-2 text-sm text-mnc-muted">Use essa tela para importar planilhas no formato do arquivo "Controle de Perdas". O sistema faz upsert por chave operacional (data + OP + cliente + pedido).</p>
</section>

<?php if ($err): ?>
  <div class="mt-4 rounded-xl border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700"><?= e($err) ?></div>
<?php endif; ?>
<?php if ($ok): ?>
  <div class="mt-4 rounded-xl border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800"><?= e($ok) ?></div>
<?php endif; ?>

<section class="glass-card mt-4 p-5 md:p-6">
  <form method="post" enctype="multipart/form-data" class="grid gap-3 md:grid-cols-[1fr_auto] md:items-end">
    <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
    <div>
      <label class="mb-1 block text-xs font-semibold uppercase tracking-[0.12em] text-mnc-muted">Arquivo XLSX</label>
      <input type="file" name="arquivo_xlsx" accept=".xlsx" class="input-dark" required>
    </div>
    <button class="btn-primary">Importar Agora</button>
  </form>

  <?php if ($result): ?>
    <div class="mt-5 grid gap-3 sm:grid-cols-2 xl:grid-cols-5">
      <div class="rounded-2xl border border-slate-200 bg-white p-4">
        <div class="kpi-value"><?= (int)$result['processed'] ?></div>
        <div class="kpi-label">Linhas Processadas</div>
      </div>
      <div class="rounded-2xl border border-slate-200 bg-white p-4">
        <div class="kpi-value text-emerald-700"><?= (int)$result['inserted'] ?></div>
        <div class="kpi-label">Inseridas</div>
      </div>
      <div class="rounded-2xl border border-slate-200 bg-white p-4">
        <div class="kpi-value text-cyan-700"><?= (int)$result['updated'] ?></div>
        <div class="kpi-label">Atualizadas</div>
      </div>
      <div class="rounded-2xl border border-slate-200 bg-white p-4">
        <div class="kpi-value text-amber-700"><?= (int)$result['skipped'] ?></div>
        <div class="kpi-label">Ignoradas</div>
      </div>
      <div class="rounded-2xl border border-slate-200 bg-white p-4">
        <div class="kpi-value"><?= e(implode(', ', $result['sheets'])) ?></div>
        <div class="kpi-label">Abas Lidas</div>
      </div>
    </div>
  <?php endif; ?>
</section>

<?php require __DIR__ . '/_layout_bottom.php'; ?>
