<?php
require __DIR__ . '/../db.php';
require __DIR__ . '/../auth.php';
require __DIR__ . '/../helpers.php';

$cfg = app_config();
$base = app_base_url();

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  $email = trim($_POST['email'] ?? '');
  $senha = (string)($_POST['senha'] ?? '');

  $stmt = db()->prepare('SELECT id, nome, email, senha_hash, ativo FROM bi_users WHERE email = ? LIMIT 1');
  $stmt->execute([$email]);
  $u = $stmt->fetch();

  if (!$u || (int)$u['ativo'] !== 1 || !password_verify($senha, $u['senha_hash'])) {
    $err = 'E-mail ou senha invalidos.';
  } else {
    $_SESSION['user'] = ['id' => $u['id'], 'nome' => $u['nome'], 'email' => $u['email']];
    if (password_needs_rehash($u['senha_hash'], PASSWORD_DEFAULT)) {
      $newHash = password_hash($senha, PASSWORD_DEFAULT);
      db()->prepare('UPDATE bi_users SET senha_hash = ? WHERE id = ?')->execute([$newHash, $u['id']]);
    }
    header('Location: ' . route_url(current_module()['default_page'] ?? 'dashboard'));
    exit;
  }
}
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>Login - <?= e($cfg['app']['name']) ?></title>
  <script src="https://cdn.tailwindcss.com?plugins=forms"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            mnc: {
              bg: '#f4f8ff',
              text: '#0f172a',
              muted: '#64748b'
            }
          },
          fontFamily: {
            sans: ['Manrope', 'ui-sans-serif', 'system-ui']
          }
        }
      }
    };
  </script>
  <link rel="stylesheet" href="<?= e($base) ?>/assets/style.css">
</head>
<body class="min-h-screen bg-mnc-bg text-mnc-text">
  <div class="page-bg"></div>

  <main class="mx-auto grid min-h-screen w-full max-w-6xl items-center px-4 py-8 md:px-8">
    <section class="glass-card overflow-hidden">
      <div class="grid gap-0 lg:grid-cols-2">
        <div class="space-y-6 p-7 md:p-10">
          <img src="<?= e($base) ?>/assets/img/logo-manancial.png" alt="Manancial" class="h-10 w-auto">
          <div>
            <p class="text-sm uppercase tracking-[0.2em] text-mnc-muted">MANANCIAL BI</p>
            <h1 class="mt-3 text-3xl font-extrabold leading-tight">Modelo 01 de BI pronto para operar e escalar</h1>
            <p class="mt-3 max-w-lg text-sm text-mnc-muted">Dashboard, lista de registros, cadastro completo e indicadores com base preparada para novos modelos.</p>
          </div>

          <div class="grid gap-3 sm:grid-cols-2">
            <article class="rounded-2xl border border-slate-200 bg-white p-4">
              <p class="text-xs uppercase tracking-[0.14em] text-mnc-muted">Ativo</p>
              <p class="mt-2 text-lg font-bold">Controle de Perdas</p>
            </article>
            <article class="rounded-2xl border border-slate-200 bg-white p-4">
              <p class="text-xs uppercase tracking-[0.14em] text-mnc-muted">Escalavel</p>
              <p class="mt-2 text-lg font-bold">Novos Modelos</p>
            </article>
          </div>
        </div>

        <div class="border-t border-slate-200 bg-slate-50/70 p-7 md:p-10 lg:border-l lg:border-t-0">
          <h2 class="text-2xl font-extrabold">Acessar</h2>
          <p class="mt-2 text-sm text-mnc-muted">Use as credenciais do ambiente para entrar.</p>

          <?php if ($err): ?>
            <div class="mt-4 rounded-xl border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700"><?= e($err) ?></div>
          <?php endif; ?>

          <form method="post" action="<?= e(route_url('login')) ?>" class="mt-6 space-y-4">
            <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
            <div>
              <label class="mb-1 block text-sm font-semibold text-mnc-muted">E-mail</label>
              <input type="email" class="input-dark" name="email" required placeholder="admin@manancial.local" value="<?= e($_POST['email'] ?? '') ?>">
            </div>
            <div>
              <label class="mb-1 block text-sm font-semibold text-mnc-muted">Senha</label>
              <input type="password" class="input-dark" name="senha" required placeholder="********">
            </div>

            <button class="btn-primary w-full">Entrar</button>
          </form>

          <div class="mt-5 rounded-xl border border-cyan-200 bg-cyan-50 px-4 py-3 text-xs text-cyan-800">
            Usuario padrao: <strong>admin@manancial.local</strong> / <strong>Admin@123</strong>
          </div>
        </div>
      </div>
    </section>
  </main>
</body>
</html>
