<?php
$app = app_config();
$appName = $app['app']['name'] ?? 'MANANCIAL BI';
$base = app_base_url();
$user = auth_user();
$moduleKey = current_module_key();
$module = current_module();
$modulePages = $module['pages'] ?? [];
$allModules = bi_modules();
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title><?= e($appName) ?></title>
  <script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            mnc: {
              bg: '#f4f8ff',
              card: '#ffffff',
              line: 'rgba(15,23,42,0.12)',
              text: '#0f172a',
              muted: '#64748b',
              cyan: '#28c7f6',
              mint: '#2ce5a7'
            }
          },
          fontFamily: {
            sans: ['Manrope', 'ui-sans-serif', 'system-ui']
          },
          boxShadow: {
            glow: '0 18px 40px rgba(8, 23, 46, .55)'
          }
        }
      }
    };
  </script>
  <link rel="stylesheet" href="<?= e($base) ?>/assets/style.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.min.css">
  <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>
  <script src="https://cdn.datatables.net/2.1.8/js/dataTables.min.js"></script>
</head>
<body class="min-h-screen text-mnc-text">
  <div class="page-bg"></div>

  <header class="sticky top-0 z-40 border-b border-slate-200 bg-white/90 backdrop-blur-xl">
    <div class="mx-auto flex w-full max-w-[1600px] items-center justify-between gap-4 px-4 py-3 lg:px-8">
      <a href="<?= e(route_url($module['default_page'] ?? 'dashboard')) ?>" class="flex min-w-0 items-center gap-3">
        <img class="h-8 w-auto" src="<?= e($base) ?>/assets/img/logo-manancial.png" alt="Manancial">
        <div class="min-w-0">
          <div class="truncate text-sm font-extrabold uppercase tracking-[0.18em] text-mnc-muted"><?= e($appName) ?></div>
          <div class="truncate text-lg font-bold text-slate-900">
            <?= e($module['name'] ?? 'Modelo') ?>
            <span class="ml-2 rounded-full border border-cyan-300/50 bg-cyan-100 px-2 py-0.5 text-xs font-semibold text-cyan-800"><?= e($module['description'] ?? '') ?></span>
          </div>
        </div>
      </a>

      <div class="hidden items-center gap-2 lg:flex">
        <?php foreach ($modulePages as $pageKey => $pageMeta): ?>
          <?php if (!($pageMeta['nav'] ?? false)) continue; ?>
          <a class="nav-pill <?= ($pageKey === ($_GET['p'] ?? 'dashboard')) ? 'nav-pill-active' : '' ?>" href="<?= e(route_url($pageKey)) ?>"><?= e($pageMeta['label'] ?? $pageKey) ?></a>
        <?php endforeach; ?>
      </div>

      <div class="flex items-center gap-2">
        <form method="get" class="hidden md:block">
          <input type="hidden" name="p" value="<?= e($_GET['p'] ?? ($module['default_page'] ?? 'dashboard')) ?>">
          <select name="m" onchange="this.form.submit()" class="rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm text-slate-800">
            <?php foreach ($allModules as $key => $meta): ?>
              <option value="<?= e($key) ?>" <?= $key === $moduleKey ? 'selected' : '' ?>><?= e(($meta['name'] ?? $key) . ' - ' . ($meta['description'] ?? '')) ?></option>
            <?php endforeach; ?>
          </select>
        </form>

        <?php if ($user): ?>
          <div class="hidden text-right md:block">
            <div class="text-xs uppercase tracking-[0.12em] text-mnc-muted">Logado</div>
            <div class="text-sm font-semibold"><?= e($user['nome'] ?? 'Usuario') ?></div>
          </div>
          <a class="rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm font-semibold text-slate-800 hover:bg-slate-50" href="<?= e(route_url('logout')) ?>">Sair</a>
        <?php endif; ?>
      </div>
    </div>

    <div class="mx-auto flex w-full max-w-[1600px] gap-2 overflow-x-auto px-4 pb-3 lg:hidden lg:px-8">
      <?php foreach ($modulePages as $pageKey => $pageMeta): ?>
        <?php if (!($pageMeta['nav'] ?? false)) continue; ?>
        <a class="nav-pill whitespace-nowrap <?= ($pageKey === ($_GET['p'] ?? 'dashboard')) ? 'nav-pill-active' : '' ?>" href="<?= e(route_url($pageKey)) ?>"><?= e($pageMeta['label'] ?? $pageKey) ?></a>
      <?php endforeach; ?>
    </div>
  </header>

  <main class="mx-auto w-full max-w-[1600px] px-4 py-6 lg:px-8">
