<?php
// app/db.php (versão blindada)

if (!function_exists('db')) {

    function db(): PDO {

        static $pdo = null;
        if ($pdo) return $pdo;

        $cfg = (require __DIR__ . '/config.php')['db'];

        $dsn = "mysql:host={$cfg['host']};dbname={$cfg['name']};charset={$cfg['charset']}";

        $opts = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];

        $pdo = new PDO($dsn, $cfg['user'], $cfg['pass'], $opts);

        return $pdo;
    }

}
