<?php
// app/auth.php  (versão protegida contra redeclare)
$config = require __DIR__ . '/config.php';

if (!defined('MANANCIAL_BI_BOOT')) {
  define('MANANCIAL_BI_BOOT', 1);
}

if (!isset($config['app']['session_name'])) {
  $config['app']['session_name'] = 'manancial_bi_sess';
}

if (session_status() !== PHP_SESSION_ACTIVE) {
  session_name($config['app']['session_name']);
  session_start();
}

if (!function_exists('auth_user')) {
  function auth_user() {
    return $_SESSION['user'] ?? null;
  }
}

if (!function_exists('require_auth')) {
  function require_auth() {
    if (!auth_user()) {
      $module = (string)($_SESSION['module'] ?? ($_GET['m'] ?? ''));
      $target = 'index.php?p=login';
      if ($module !== '') {
        $target .= '&m=' . rawurlencode($module);
      }
      header('Location: ' . $target);
      exit;
    }
  }
}

if (!function_exists('csrf_token')) {
  function csrf_token(): string {
    if (empty($_SESSION['csrf'])) {
      $_SESSION['csrf'] = bin2hex(random_bytes(16));
    }
    return $_SESSION['csrf'];
  }
}

if (!function_exists('csrf_check')) {
  function csrf_check(): void {
    $t = $_POST['_csrf'] ?? '';
    if (!$t || empty($_SESSION['csrf']) || !hash_equals($_SESSION['csrf'], $t)) {
      http_response_code(403);
      echo "CSRF inválido.";
      exit;
    }
  }
}
