# MANANCIAL BI - Modulo 01 (Controle de Perdas)

Base PHP + MySQL pronta para operar o primeiro modelo e escalar para novos modelos.

## Requisitos
- PHP 7.4+ (recomendado 8.x)
- MySQL 5.7+ ou MariaDB 10+
- Extensoes: `PDO`, `pdo_mysql`

## Instalacao
1. Crie o banco `bi_manancial`.
2. Importe `sql/schema.sql`.
3. Rode `composer install` (necessario para importacao XLSX).
4. Ajuste credenciais em `app/config.php`.
5. Acesse `public/index.php`.

## Usuario padrao
- Email: `admin@manancial.local`
- Senha: `Admin@123`

## O que esta pronto
- Login seguro com `password_hash` e CSRF.
- Dashboard com KPIs e graficos (Chart.js).
- Lista e cadastro de perdas com calculos automaticos.
- Importacao de planilha XLSX (abas JANEIRO/FEVEREIRO e formato equivalente).
- Visao de dados no dashboard em formato planilha.
- Layout Tailwind responsivo.
- Estrutura de modulos em `app/modules.php` para incluir novos modelos depois.

## Como adicionar novo modelo depois
1. Adicione um novo item em `app/modules.php`.
2. Crie as novas paginas e registre em `pages` do modulo.
3. A navegacao e roteamento ja passam a reconhecer o novo modulo.
